/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_finalize.c,v 1.15 2005/06/29 00:23:16 eugene Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "mx_auto_config.h"
#include "myriexpress.h"
#include "internal.h"

mx_return_t
mx_finalize(void)
{
    
    pthread_mutex_lock(&Mx_po_lock);
    if (Mx_init_count > 0) {
        --Mx_init_count;
    }
    if (Mx_init_count == 0) {
        MX_DEBUG_PRINT(MX_DEBUG_TCP_LIB,("last time\n"));
        Mx_main_cancel = 1;
        pthread_cond_signal(&Mx_send_cond);
        pthread_mutex_unlock(&Mx_po_lock);
        pthread_join(Mx_tx_thread, NULL);
        pthread_join(Mx_rx_thread, NULL);
        MX_LIST_APPLY(struct mx_endpoint, &Mx_endpoints, mx_close_endpoint);
        pthread_mutex_lock(&Mx_po_lock);
    }
    pthread_mutex_unlock(&Mx_po_lock);
    return MX_SUCCESS;
}
